package gov.va.med.mhv.journal.repository;

import gov.va.med.mhv.journal.data.model.ActivityJournal;

import java.util.Date;
import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ActivityJournalRepository extends JpaRepository<ActivityJournal, Long> {

	@Query("select j " +
			"from ActivityJournal j " +
			"where j.userId = :userId " +
			"order by j.journalDate desc")
	public List<ActivityJournal> findActivityJournalsForUser(@Param("userId") Long userId);
	
	@Query("select j " +
			"from ActivityJournal j " +
			"where j.userId = :userId " +
			"order by j.journalDate desc")
	public List<ActivityJournal> getDashBoardActivityJournalsForUser(@Param("userId") Long userId, Pageable page);
	
	@Query("select j " +
			"from ActivityJournal j " +
			"where j.userId = :userId " +
			"and j.journalDate = :journalDate")
	public List<ActivityJournal> findActivityJournalsForUserAndDate(@Param("userId") Long userId, @Param("journalDate") Date journalDate);
}
